var samplePageObj = {
  // 샘플 타이틀
  title: '관계형 콤보',

  subtitle: '대분류/중분류/소분류에 따른 관계형 콤보 예제입니다.',
  // 샘플 설명
  desc: '각 콤보 컬럼의 관계에 따라서 조회/수정시 연결된 다른 컬럼의 콤보값을 세팅합니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0,
      MaxPages: 3,
      SuppressMessage: 3
    },
    LeftCols: [
      {
        Type: 'Int',
        Width: 50,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: '대분류',
        Type: 'Enum',
        Name: 'Category1',
        Width: '150',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        Enum: '|가정/살림|경제 경영|국어 외국어 사전|만화/라이트노벨|소설/시/희곡|어린이|역사|예술|인문|자기계발|자연과학',
        EnumKeys: '|A0|A1|A2|A3|A4|A5|A7|A8|A9|A10|A11',
        Clear: 'Category2,Category3'
      },
      {
        Header: '중분류',
        Type: 'Enum',
        Name: 'Category2',
        Width: '150',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        Related: 'Category1',
        Clear: 'Category3',
        EnumA0: '|요리|자녀교육',
        EnumKeysA0: '|AA0|AA1',
        EnumA1: '|경제|투자/재테크|마케팅/세일즈',
        EnumKeysA1: '|AB0|AB1|AB2',
        EnumA2: '|영어|일본어|중국어|프랑스어',
        EnumKeysA2: '|AC0|AC1|AC2|AC3',
        EnumA3: '|판타지/드라마|순정/학원',
        EnumKeysA3: '|AD0|AD1',
        EnumA4: '|한국소설|시/희곡|일본소설|프랑스소설',
        EnumKeysA4: '|AF0|AF1|AF2|AF3',
        EnumA5: '|학습만화/코믹스|어린이 문학|초등학습',
        EnumKeysA5: '|AG0|AG1|AG2',
        EnumA7: '|한국사/한국문화|동양사/동양문화|서양사/서양문화',
        EnumKeysA7: '|AI0|AI1|AI2',
        EnumA8: '|미술|건축|사진|무용',
        EnumKeysA8: '|AJ0|AJ1|AJ2|AJ3',
        EnumA9: '|철학/사상|인문일반|심리',
        EnumKeysA9: '|AK0|AK1|AK2',
        EnumA10: '|처세술/삶의 자세|인간관계|기획/정보/시간관리',
        EnumKeysA10: '|AL0|AL1|AL2',
        EnumA11: '|천문학|물리학|화학',
        EnumKeysA11: '|AM0|AM1|AM2',
      },
      {
        Header: '소분류',
        Type: 'Enum',
        Name: 'Category3',
        Width: '150',
        Align: 'Center',
        CanEdit: 1,
        Related: 'Category2',
        EnumAA0: '|생활요리|상황별요리|홈베이킹/베이커리',
        EnumKeysAA0: '|AAA0|AAA1|AAA2',
        EnumAA1: '|학습법일반|좋은부모되기|놀이교육|독서교육',
        EnumKeysAA1: '|AAB0|AAB1|AAB2|AAB3',
        EnumAB0: '|경제사상과 이론|지역경제|경제상식/경제이야기',
        EnumKeysAB0: '|ABA0|ABA1|ABA2',
        EnumAB1: '|재테크일반|부동산/경매|외환투자|주식/증권',
        EnumKeysAB1: '|ABB0|ABB1|ABB2|ABB3',
        EnumAB2: '|트렌드/미래예측|네트워크 마케팅|영업/세일즈|마케팅/브랜드',
        EnumKeysAB2: '|ABC0|ABC1|ABC2|ABC3',
        EnumAC0: '|토익|비즈니스|영어 사전|영어 어휘|텝스',
        EnumKeysAC0: '|ACA0|ACA1|ACA2|ACA3|ACA4',
        EnumAC1: '|JPT|JLPT|비즈니스|일본어 사전',
        EnumKeysAC1: '|ACB0|ACB1|ACB2|ACB3',
        EnumAC2: '|비즈니스|중국어 사전|중국어 회화|중국어 독해/문법/작문',
        EnumKeysAC2: '|ACC0|ACC1|ACC2|ACC3',
        EnumAC3: '|비즈니스|프랑스어 사전|일반 회화',
        EnumKeysAC3: '|ACD0|ACD1|ACD2',
        EnumAD0: '|판타지|드라마',
        EnumKeysAD0: '|ADA0|ADA1',
        EnumAD1: '|순정|학원',
        EnumKeysAD1: '|ADB0|ADB1',
        EnumAF0: '|한국 단편소설|한국 장편소설',
        EnumKeysAF0: '|AFA0|AFA1',
        EnumAF1: '|한국시|한시/옛시|희곡/시나리오|세계의 시',
        EnumKeysAF1: '|AFB0|AFB1|AFB2|AFB3',
        EnumAF2: '|일본 단편소설|일본 장편소설',
        EnumKeysAF2: '|AFC0|AFC1',
        EnumAF3: '|프랑스 단편소설|프랑스 장편소설',
        EnumKeysAF3: '|AFD0|AFD1',
        EnumAG0: '|역사/인물만화|학습만화|만화/애니메이션',
        EnumKeysAG0: '|AGA0|AGA1|AGA2',
        EnumAG1: '|그림책|동화책|동요|그래픽노블',
        EnumKeysAG1: '|AGB0|AGB1|AGB2|AGB3',
        EnumAG2: '|한국사/세계사/지리|경제|과학/환경|글짓기|영어',
        EnumKeysAG2: '|AGC0|AGC1|AGC2|AGC3|AGC4',
        EnumAI0: '|삼국시대 이전|고려시대|조선시대|정부수립이후',
        EnumKeysAI0: '|AIA0|AIA1|AIA2|AIA3',
        EnumAI1: '|중국역사/문화|일본역사/문화|동양사/동양문화 일반',
        EnumKeysAI1: '|AIB0|AIB1|AIB2',
        EnumAI2: '|서양고중세사|서양근현대사|동유럽역사/문화|미국역사/문화',
        EnumKeysAI2: '|AIC0|AIC1|AIC2|AIC3',
        EnumAJ0: '|미술일반/교양|디자인|종교미술|컬러링',
        EnumKeysAJ0: '|AJA0|AJA1|AJA2|AJA3',
        EnumAJ1: '|건축이론|비평|건축사',
        EnumKeysAJ1: '|AJB0|AJB1|AJB2',
        EnumAJ2: '|사진비평|사진실기|사진일반|사진집',
        EnumKeysAJ2: '|AJC0|AJC1|AJC2|AJC3',
        EnumAJ3: '|무용이론|무용사|무용일반|무용비평',
        EnumKeysAJ3: '|AJD0|AJD1|AJD2|AJD3',
        EnumAK0: '|쉽게읽는 철학|철학의 이해|공리주의|인간론|과학철학',
        EnumKeysAK0: '|AKA0|AKA1|AKA2|AKA3|AKA4',
        EnumAK1: '|인문/교양 일반|인문학 사전|인문학 이론',
        EnumKeysAK1: '|AKB0|AKB1|AKB2',
        EnumAK2: '|쉽게 읽는 심리학|심리학 이론|카운셀링/심리치료',
        EnumKeysAK2: '|AKC0|AKC1|AKC2',
        EnumAL0: '|처세술|삶의 자세',
        EnumKeysAL0: '|ALA0|ALA1',
        EnumAL1: '|심리/성경/설득|남녀관계/연애|인간관계 일반',
        EnumKeysAL1: '|ALB0|ALB1|ALB2',
        EnumAL2: '|기획관리|정보관리|시간관리',
        EnumKeysAL2: '|ALC0|ALC1|ALC2',
        EnumAM0: '|별자리와 천체관측|천문학 일반|UFO와 외계생명체',
        EnumKeysAM0: '|AMA0|AMA1|AMA2',
        EnumAM1: '|고전물리|물리학 일반|전자기학',
        EnumKeysAM1: '|AMB0|AMB1|AMB2',
        EnumAM2: '|물리|화학 일반|유기화학',
        EnumKeysAM2: '|AMC0|AMC1|AMC2',
      },
      {
        Header: '상품번호',
        Type: 'Text',
        Name: 'ItemNo',
        Width: '80',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1
      },
      {
        Header: '도서명',
        Type: 'Text',
        Name: 'Title',
        MinWidth: '250',
        Align: 'Left',
        CanEdit: 1,
        RawSort: 1,
        RelWidth: 1
      },
      {
        Header: '가격',
        Type: 'Int',
        Name: 'Price',
        Width: '90',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Format: '#,##0원'
      },
      {
        Header: '저자',
        Type: 'Text',
        Name: 'Author',
        MinWidth: '220',
        Align: 'Left',
        CanEdit: 1,
        RawSort: 1,
        RelWidth: 1
      },
      {
        Header: '출판사',
        Type: 'Text',
        Name: 'Publisher',
        Width: '120',
        Align: 'Left',
        CanEdit: 1,
        RawSort: 1
      },

    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      ItemNo: 59993940,
      Title: '공부머리 독서법',
      Price: 14850,
      Author: '최승필',
      Publisher: '책구루',
      Category1: 'A0',
      Category2: 'AA1',
      Category3: 'AAB0'
    },
    {
      ItemNo: 68749139,
      Title: '철학은 어떻게 삶의 무기가 되는가',
      Price: 14400,
      Author: '야마구치 슈/김윤경',
      Publisher: '다산초당',
      Category1: 'A9',
      Category2: 'AK0',
      Category3: 'AKA0'
    },
    {
      ItemNo: 69620818,
      Title: '원피스 ONE PIECE 91',
      Price: 4500,
      Author: '오다 에이이치로',
      Publisher: '대원',
      Category1: 'A3',
      Category2: 'AD0',
      Category3: 'ADA0'
    },
    {
      ItemNo: 69279594,
      Title: '우린 너무 몰랐다',
      Price: 16200,
      Author: '김용옥',
      Publisher: '통나무',
      Category1: 'A7',
      Category2: 'AI0',
      Category3: 'AIA0'
    },
    {
      ItemNo: 61980545,
      Title: '댄 애리얼리 부의 감각',
      Price: 16200,
      Author: '제프 크라이슬러/댄 애리얼리/이경식',
      Publisher: '청림출판',
      Category1: 'A1',
      Category2: 'AB0',
      Category3: 'ABA0'
    },
    {
      ItemNo: 69063509,
      Title: '[예약판매] 설민석의 한국사 대모험 9',
      Price: 9450,
      Author: '설민석 /스토리박스/정현희/태건 역사 연구소',
      Publisher: '아이휴먼',
      Category1: 'A5',
      Category2: 'AG0',
      Category3: 'AGA0'
    },
    {
      ItemNo: 69289632,
      Title: '에어프라이어 만능 레시피북',
      Price: 10800,
      Author: '강지현',
      Publisher: '엔트리',
      Category1: 'A0',
      Category2: 'AA0',
      Category3: 'AAA0'
    },
    {
      ItemNo: 24259730,
      Title: '꽃을 보듯 너를 본다',
      Price: 9000,
      Author: '나태주',
      Publisher: '지혜',
      Category1: 'A4',
      Category2: 'AF0',
      Category3: 'AFA0'
    },
    {
      ItemNo: 66360714,
      Title: '12가지 인생의 법칙',
      Price: 15120,
      Author: '조던 B. 피터슨',
      Publisher: '메이븐',
      Category1: 'A9',
      Category2: 'AK1',
      Category3: 'AKB0'
    },
    {
      ItemNo: 35552641,
      Title: '돌이킬 수 없는 약속',
      Price: 13500,
      Author: '야쿠마루 가쿠/김성미',
      Publisher: '북플라자',
      Category1: 'A4',
      Category2: 'AF1',
      Category3: 'AFB0'
    },
    {
      ItemNo: 65564967,
      Title: '수미네 반찬',
      Price: 15300,
      Author: '김수미/여경래/최현석/미카엘 아쉬미노프',
      Publisher: '성안당',
      Category1: 'A0',
      Category2: 'AA0',
      Category3: 'AAA0'
    },
    {
      ItemNo: 67478818,
      Title: '6개월에 천만 모으기',
      Price: 14400,
      Author: '이대표/성선화/김유라/서영아',
      Publisher: '한국경제신문사(한경비피)',
      Category1: 'A1',
      Category2: 'AB1',
      Category3: 'ABB0'
    },
    {
      ItemNo: 68832866,
      Title: '마력의 태동',
      Price: 12600,
      Author: '히가시노 게이고/양윤옥',
      Publisher: '현대문학',
      Category1: 'A4',
      Category2: 'AF1',
      Category3: 'AFB0'
    },
    {
      ItemNo: 69279358,
      Title: '마법천자문 44',
      Price: 8820,
      Author: '김현수/홍거북/김창환',
      Publisher: '아울북',
      Category1: 'A5',
      Category2: 'AG0',
      Category3: 'AGA1'
    },
    {
      ItemNo: 64694842,
      Title: '당신이 옳다',
      Price: 14220,
      Author: '정혜신',
      Publisher: '해냄',
      Category1: 'A9',
      Category2: 'AK1',
      Category3: 'AKB0'
    },
    {
      ItemNo: 67211707,
      Title: 'ETS 토익 정기시험 기출문제집 1000 READING 리딩',
      Price: 16020,
      Author: 'ETS',
      Publisher: 'YBM(와이비엠)',
      Category1: 'A2',
      Category2: 'AC0',
      Category3: 'ACA0'
    },
    {
      ItemNo: 67211652,
      Title: 'ETS 토익 정기시험 기출문제집 1000 LISTENING 리스닝',
      Price: 16020,
      Author: 'ETS',
      Publisher: 'YBM(와이비엠)',
      Category1: 'A2',
      Category2: 'AC0',
      Category3: 'ACA0'
    },
    {
      ItemNo: 67362730,
      Title: '해커스 토익 기출 보카',
      Price: 11610,
      Author: 'David Cho 저',
      Publisher: '해커스어학연구소',
      Category1: 'A2',
      Category2: 'AC0',
      Category3: 'ACA0'
    },
    {
      ItemNo: 69053884,
      Title: '나는 습관을 조금 바꾸기로 했다',
      Price: 13500,
      Author: '사사키 후미오/정지영/드로잉메리',
      Publisher: '쌤앤파커스',
      Category1: 'A10',
      Category2: 'AL0',
      Category3: 'ALA0'
    },
    {
      ItemNo: 67094938,
      Title: '아이를 위한 하루 한 줄 인문학',
      Price: 13050,
      Author: '김종원',
      Publisher: '청림Life',
      Category1: 'A0',
      Category2: 'AA1',
      Category3: 'AAB0'
    },
    {
      ItemNo: 68314988,
      Title: '초등 자존감의 힘',
      Price: 12600,
      Author: '김선호/박우란',
      Publisher: '길벗',
      Category1: 'A0',
      Category2: 'AA1',
      Category3: 'AAB1'
    },
    {
      ItemNo: 67507594,
      Title: '104층 나무 집',
      Price: 10800,
      Author: '앤디 그리피스/신수진/테리 덴톤',
      Publisher: '시공주니어',
      Category1: 'A5',
      Category2: 'AG1',
      Category3: 'AGB0'
    },
    {
      ItemNo: 69666530,
      Title: '[예약판매] 나츠메 우인장 23',
      Price: 4050,
      Author: '미도리카와 유키',
      Publisher: '학산문화사',
      Category1: 'A3',
      Category2: 'AD1',
      Category3: 'ADB1'
    },
    {
      ItemNo: 66909910,
      Title: '아가씨와 밤',
      Price: 13050,
      Author: '기욤 뮈소/양영란',
      Publisher: '밝은세상',
      Category1: 'A4',
      Category2: 'AF2',
      Category3: 'AFC0'
    },
    {
      ItemNo: 69065351,
      Title: 'Go Go 카카오프렌즈 6',
      Price: 10800,
      Author: '김미영/김정한',
      Publisher: '아울북',
      Category1: 'A5',
      Category2: 'AG2',
      Category3: 'AGC0'
    },
    {
      ItemNo: 63038113,
      Title: '방구석 미술관',
      Price: 15120,
      Author: '조',
      Publisher: '블랙피쉬',
      Category1: 'A8',
      Category2: 'AJ0',
      Category3: 'AJA0'
    },
    {
      ItemNo: 65100984,
      Title: '트렌드 코리아 2019',
      Price: 15300,
      Author: '김난도/이수진/서유현/최지혜/김서영/전미영/이향은/이준영/권정윤',
      Publisher: '미래의창',
      Category1: 'A1',
      Category2: 'AB2',
      Category3: 'ABC0'
    },
    {
      ItemNo: 67543979,
      Title: '오은영의 화해',
      Price: 14400,
      Author: '오은영',
      Publisher: '코리아닷컴(Korea.com)',
      Category1: 'A10',
      Category2: 'AL1',
      Category3: 'ALB0'
    },
    {
      ItemNo: 66992093,
      Title: '다산의 마지막 공부',
      Price: 13500,
      Author: '조윤제',
      Publisher: '청림출판',
      Category1: 'A10',
      Category2: 'AL0',
      Category3: 'ALA0'
    },
    {
      ItemNo: 69304858,
      Title: '나를 채우는 인문학',
      Price: 16650,
      Author: '최진기',
      Publisher: '이지퍼블리싱',
      Category1: 'A9',
      Category2: 'AK1',
      Category3: 'AKB1'
    },
    {
      ItemNo: 69055262,
      Title: '공부 마스터 플랜',
      Price: 13500,
      Author: '조승우',
      Publisher: '포레스트북스',
      Category1: 'A10',
      Category2: 'AL2',
      Category3: 'ALC0'
    },
    {
      ItemNo: 58774995,
      Title: '부자 아빠 가난한 아빠 20주년 특별 기념판',
      Price: 14220,
      Author: '로버트 기요사키/안진환',
      Publisher: '민음인',
      Category1: 'A1',
      Category2: 'AB1',
      Category3: 'ABB0'
    },
    {
      ItemNo: 23030284,
      Title: '사피엔스',
      Price: 19800,
      Author: '유발 하라리/조현욱',
      Publisher: '김영사',
      Category1: 'A9',
      Category2: 'AK1',
      Category3: 'AKB0'
    },
    {
      ItemNo: 67110522,
      Title: '아침에는 죽음을 생각하는 것이 좋다',
      Price: 13500,
      Author: '김영민',
      Publisher: '어크로스',
      Category1: 'A9',
      Category2: 'AK1',
      Category3: 'AKB0'
    },
    {
      ItemNo: 2312211,
      Title: '코스모스',
      Price: 16650,
      Author: '칼 세이건/홍승수',
      Publisher: '사이언스북스',
      Category1: 'A11',
      Category2: 'AM0',
      Category3: 'AMA0'
    },
    {
      ItemNo: 69659243,
      Title: '[예약판매] 좀비고등학교 코믹스 11',
      Price: 8820,
      Author: '유대영/라임스튜디오',
      Publisher: '겜툰',
      Category1: 'A5',
      Category2: 'AG0',
      Category3: 'AGA2'
    }
  ]

};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
